/*
 * Decompiled with CFR 0.152.
 */
package us.oh.state.common.utility;

import us.oh.state.common.utility.ChartGraphics;
import us.oh.state.common.utility.Renderable;

public abstract class ValueSet
implements Renderable {
    private String name;
    private double lineThickness;
    private int lineColor;
    private double[] values;
    private int currentIndex = 0;
    private boolean isScaleSet = false;
    private double scale = 1.0;
    private double minValue;
    private double maxValue;
    private double baseValue = 0.0;

    public String getName() {
        return this.name;
    }

    public double getFirstValue() {
        this.currentIndex = 0;
        return this.getNextValue();
    }

    public double getNextValue() {
        return this.getValue(this.currentIndex++);
    }

    public int getValueCount() {
        this.currentIndex = 0;
        return this.values.length;
    }

    public double getLineThickness() {
        return this.lineThickness;
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public double getValue(int n) {
        if (this.isScaleSet) {
            return (this.values[n] - this.baseValue) * this.scale;
        }
        return this.baseValue;
    }

    public void setScale(double d) {
        this.isScaleSet = true;
        this.scale = d / (this.maxValue - this.minValue);
    }

    public void setRange(double d, double d2, double d3) {
        this.minValue = d;
        this.maxValue = d2;
        this.baseValue = d3;
    }

    public double getBaseValue() {
        if (this.isScaleSet) {
            return (this.baseValue - this.minValue) * this.scale;
        }
        return this.baseValue;
    }

    public abstract void render(ChartGraphics var1);

    public abstract void sample(ChartGraphics var1, double var2, double var4, double var6, double var8);

    public boolean isBehindGrid() {
        return false;
    }

    public ValueSet(String string, double d, int n, double[] dArray) {
        this.name = string;
        this.lineThickness = d;
        this.lineColor = n;
        this.values = dArray;
    }
}

