/*
 * Decompiled with CFR 0.152.
 */
package us.oh.state.common.utility;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PdfPage {
    public static String NORMAL = "F0";
    public static String BOLD = "F1";
    public static String FIXED = "F2";
    public static String FIXED_BOLD = "F3";
    public static String ALTERNATE = "F4";
    public static double POINTS_PER_INCH = 72.0;
    private OutputStream out = null;
    private Vector contents = null;
    private Vector graphics = null;
    private Vector objects = null;
    private Vector pages = null;
    private Hashtable resources = null;
    private long fileOffset = 0L;
    private String infoTitle = null;
    private String infoSubject = null;
    private String infoKeywords = null;
    private String infoAuthor = null;
    private String infoProducer = null;
    private String infoProgram = null;
    private boolean isInfo = false;
    private int xPos = 0;
    private int yPos = 0;
    private DecimalFormat matrixFormat = null;
    private int lead = 12;
    private int pageWidth = 612;
    private int pageHeight = 792;
    private int leftMargin = 20;
    private int topMargin = 762;
    private DecimalFormat geoDecimal = null;
    private boolean needStroke = true;
    private String font = NORMAL;
    private int size = 12;

    private void start() {
        this.produce("%PDF-1.0\n");
        this.objects = new Vector();
        this.pages = new Vector();
        this.contents = new Vector();
        this.graphics = new Vector();
        this.resources = new Hashtable();
        this.pageBreak();
    }

    public void info(String string, String string2, String string3, String string4, String string5, String string6) {
        this.isInfo = true;
        this.infoTitle = string;
        this.infoSubject = string2;
        this.infoKeywords = string3;
        this.infoAuthor = string4;
        this.infoProducer = string5;
        this.infoProgram = string6;
    }

    private int produceInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.infoTitle != null) {
            stringBuffer.append(this.name("Title") + this.str(this.infoTitle));
        }
        if (this.infoSubject != null) {
            stringBuffer.append(this.name("Subject") + this.str(this.infoSubject));
        }
        if (this.infoKeywords != null) {
            stringBuffer.append(this.name("Keywords") + this.str(this.infoKeywords));
        }
        if (this.infoAuthor != null) {
            stringBuffer.append(this.name("Author") + this.str(this.infoAuthor));
        }
        if (this.infoProducer != null) {
            stringBuffer.append(this.name("Producer") + this.str(this.infoProducer));
        }
        if (this.infoProgram != null) {
            stringBuffer.append(this.name("Creator") + this.str(this.infoProgram));
        }
        if (stringBuffer.length() == 0) {
            return -1;
        }
        int n = this.newObject();
        this.produce(this.dictionary("Info", stringBuffer.toString()));
        return n;
    }

    private long produce(String string) {
        return this.produce(string.getBytes());
    }

    private long produce(byte[] byArray) {
        try {
            this.out.write(byArray);
            this.out.flush();
            return this.fileOffset += (long)byArray.length;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public void setTextPosition(int n, int n2) {
        this.xPos = n;
        this.yPos = n2;
        this.contents.addElement("1 0 0 1 0 0 Tm " + this.xPos + " " + this.yPos + " Td");
    }

    public void setTextPosition(double d, double d2) {
        this.xPos = (int)(d * POINTS_PER_INCH);
        this.yPos = (int)(d2 * POINTS_PER_INCH);
        this.contents.addElement("1 0 0 1 0 0 Tm " + this.xPos + " " + this.yPos + " Td");
    }

    public void moveTextPosition(double d, double d2) {
        int n = (int)(d * POINTS_PER_INCH);
        int n2 = (int)(d2 * POINTS_PER_INCH);
        this.contents.addElement(n + " " + n2 + " Td");
        this.xPos += n;
        this.yPos += n2;
    }

    public void printTextOffset(double d, double d2, String string) {
        int n = (int)(d * POINTS_PER_INCH);
        int n2 = (int)(d2 * POINTS_PER_INCH);
        this.contents.addElement(n + " " + n2 + " Td (" + string + ")Tj " + -n + " " + -n2 + " Td");
    }

    public void printTextRotated(double d, double d2, double d3, String string) {
        int n = (int)(d * POINTS_PER_INCH);
        int n2 = (int)(d2 * POINTS_PER_INCH);
        double d4 = d3 * Math.PI / 180.0;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = Math.cos(d4 += 1.5707963267948966);
        double d8 = Math.sin(d4);
        if (this.matrixFormat == null) {
            this.matrixFormat = new DecimalFormat("#.###");
        }
        this.contents.addElement(this.matrixFormat.format(d5) + " " + this.matrixFormat.format(d6) + " " + this.matrixFormat.format(d7) + " " + this.matrixFormat.format(d8) + " " + n + " " + n2 + " Tm (" + string + ")Tj");
    }

    public void setLead(int n) {
        this.lead = n;
        this.contents.addElement(this.lead + " TL");
    }

    public int getLead() {
        return this.lead;
    }

    public void setPageWidth(int n) {
        this.pageWidth = n;
    }

    public void setPageHeight(int n) {
        this.pageHeight = n;
        this.setTopMargin(n - 30);
    }

    public void setLeftMargin(int n) {
        this.leftMargin = n;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setTopMargin(int n) {
        this.topMargin = n;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public static double getRed(int n) {
        double d = (n & 0xFF0000) >> 16;
        return d / 255.0;
    }

    public static double getGreen(int n) {
        double d = (n & 0xFF00) >> 8;
        return d / 255.0;
    }

    public static double getBlue(int n) {
        double d = n & 0xFF;
        return d / 255.0;
    }

    public void setLineColor(double d, double d2, double d3) {
        if (this.needStroke) {
            this.graphics.addElement("S");
            this.needStroke = false;
        }
        this.graphics.addElement(d + " " + d2 + " " + d3 + " RG");
    }

    public void setLineColor(int n) {
        this.setLineColor(PdfPage.getRed(n), PdfPage.getGreen(n), PdfPage.getBlue(n));
    }

    public void setFillColor(double d, double d2, double d3) {
        this.graphics.addElement(d + " " + d2 + " " + d3 + " rg");
    }

    public void setFillColor(int n) {
        this.setFillColor(PdfPage.getRed(n), PdfPage.getGreen(n), PdfPage.getBlue(n));
    }

    public void setTextColor(double d, double d2, double d3) {
        this.contents.addElement(d + " " + d2 + " " + d3 + " rg");
    }

    public void setTextColor(int n) {
        this.setTextColor(PdfPage.getRed(n), PdfPage.getGreen(n), PdfPage.getBlue(n));
    }

    public void setLineWidth(double d) {
        this.graphics.addElement(d + " w");
    }

    private double grayValue(double d) {
        if ((d = 1.0 - d) < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    public void setLineDensity(double d) {
        this.graphics.addElement(this.grayValue(d) + " G");
    }

    public void setFillDensity(double d) {
        this.graphics.addElement(this.grayValue(d) + " g");
    }

    public void setTextDensity(double d) {
        this.contents.addElement(this.grayValue(d) + " g");
    }

    public void setGeoDecimal(int n) {
        StringBuffer stringBuffer = new StringBuffer("#.");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("#");
            ++n2;
        }
        stringBuffer.append(" ");
        this.geoDecimal = new DecimalFormat(stringBuffer.toString());
    }

    private String round(double d) {
        if (this.geoDecimal == null) {
            this.setGeoDecimal(1);
        }
        return this.geoDecimal.format(d);
    }

    public void moveTo(double d, double d2) {
        if (this.needStroke) {
            this.graphics.addElement("S");
            this.needStroke = false;
        }
        this.graphics.addElement(this.round(d * POINTS_PER_INCH) + this.round(d2 * POINTS_PER_INCH) + "m");
    }

    public void drawTo(double d, double d2) {
        this.graphics.addElement(this.round(d * POINTS_PER_INCH) + this.round(d2 * POINTS_PER_INCH) + "l");
        this.needStroke = true;
    }

    public void fillPoly() {
        this.graphics.addElement("b*");
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.graphics.addElement(this.round(d * POINTS_PER_INCH) + this.round(d2 * POINTS_PER_INCH) + this.round(d3 * POINTS_PER_INCH) + this.round(d4 * POINTS_PER_INCH) + this.round(d5 * POINTS_PER_INCH) + this.round(d6 * POINTS_PER_INCH) + "c");
        this.needStroke = true;
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        this.rect(d, d2, d3, d4, " re S");
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        this.rect(d, d2, d3, d4, " re B S");
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        this.rect(d, d2, d3, d4, " re W S");
    }

    private void rect(double d, double d2, double d3, double d4, String string) {
        double d5 = d * POINTS_PER_INCH;
        double d6 = d2 * POINTS_PER_INCH;
        double d7 = (d3 - d) * POINTS_PER_INCH;
        double d8 = (d4 - d2) * POINTS_PER_INCH;
        this.graphics.addElement(this.round(d5) + this.round(d6) + this.round(d7) + this.round(d8) + string);
    }

    public void pushGraphicState() {
        this.graphics.addElement("q");
    }

    public void popGraphicState() {
        this.graphics.addElement("Q");
    }

    public void placeResource(String string, double d, double d2, double d3, double d4) {
        double d5 = d * POINTS_PER_INCH;
        double d6 = d2 * POINTS_PER_INCH;
        double d7 = d3 * POINTS_PER_INCH;
        double d8 = d4 * POINTS_PER_INCH;
        this.graphics.addElement("q " + d7 + " 0 0 " + d8 + " " + d5 + " " + d6 + " cm /" + string + " Do Q");
    }

    public void println(String string) {
        this.contents.addElement("(" + string + ")Tj T*");
        this.yPos -= this.lead;
    }

    public void print(String string) {
        this.contents.addElement("(" + string + ")Tj");
    }

    public void setFont(String string, int n) {
        this.font = string;
        this.size = n;
        this.contents.addElement(this.name(this.font) + " " + this.size + " Tf");
    }

    private int newObject() {
        if (this.objects.size() > 0) {
            this.produce("\nendobj\n");
        }
        this.objects.addElement(new Long(this.fileOffset));
        int n = this.objects.size();
        this.produce(n + " 0 obj\n");
        return n;
    }

    private String str(String string) {
        return "(" + string + ")";
    }

    private String dictionary(String string) {
        return "<<" + string + ">>";
    }

    private String dictionary(String string, String string2) {
        return this.dictionary("/Type/" + string + string2);
    }

    private String array(String string) {
        return "[" + string + "]";
    }

    private String name(String string) {
        return "/" + string;
    }

    private String ref(int n) {
        return " " + n + " 0 R";
    }

    public void addResource(String string, String string2) {
        int n = this.newObject();
        this.resources.put(string, new Integer(n));
        this.produce(string2);
    }

    public void addResource(String string, byte[] byArray) {
        int n = this.newObject();
        this.resources.put(string, new Integer(n));
        this.produce(byArray);
    }

    public void pageBreak() {
        String string;
        if (this.contents.size() == 0 && this.graphics.size() == 0) {
            this.setTextPosition(this.leftMargin, this.topMargin);
            this.setFont(this.font, this.size);
            this.setLead(this.lead);
            return;
        }
        int n = this.newObject();
        this.pages.addElement(new Integer(n));
        this.produce(this.dictionary(this.name("Length") + this.ref(n + 1)));
        this.produce("\nstream\n");
        long l = this.fileOffset;
        if (this.needStroke) {
            this.graphics.addElement("S");
        }
        Enumeration enumeration = this.graphics.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.produce(string + "\n");
        }
        this.produce("BT\n");
        enumeration = this.contents.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.produce(string + "\n");
        }
        this.produce("\nET\n");
        long l2 = this.fileOffset - l;
        this.produce("endstream");
        this.newObject();
        this.produce(l2 + "");
        this.contents.removeAllElements();
        this.graphics.removeAllElements();
        this.setTextPosition(this.leftMargin, this.topMargin);
        this.setFont(this.font, this.size);
        this.setLead(this.lead);
    }

    private void font(String string, String string2) {
        this.newObject();
        this.produce(this.dictionary("Font", this.name("Name") + this.name(string) + this.name("Subtype") + this.name("Type1") + this.name("Encoding") + this.name("StandardEncoding") + this.name("BaseFont") + this.name(string2)));
    }

    public void close() throws IOException {
        this.pageBreak();
        int n = 0;
        if (this.isInfo) {
            n = this.produceInfo();
        }
        if (n < 1) {
            this.isInfo = false;
        }
        int n2 = this.objects.size() + 1;
        int n3 = this.objects.size() + this.pages.size() + 1;
        Enumeration enumeration = this.pages.elements();
        while (enumeration.hasMoreElements()) {
            this.newObject();
            this.produce(this.dictionary("Page", this.name("Parent") + this.ref(n3) + this.name("Contents") + this.ref((Integer)enumeration.nextElement())));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name("Count"));
        stringBuffer.append(" " + this.pages.size());
        stringBuffer.append(this.name("MediaBox"));
        stringBuffer.append(this.array("0 0 " + this.pageWidth + " " + this.pageHeight));
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.name(NORMAL));
        stringBuffer2.append(this.ref(n3 + 1));
        stringBuffer2.append(this.name(BOLD));
        stringBuffer2.append(this.ref(n3 + 2));
        stringBuffer2.append(this.name(FIXED));
        stringBuffer2.append(this.ref(n3 + 3));
        stringBuffer2.append(this.name(FIXED_BOLD));
        stringBuffer2.append(this.ref(n3 + 4));
        stringBuffer2.append(this.name(ALTERNATE));
        stringBuffer2.append(this.ref(n3 + 5));
        String string = "";
        if (this.resources.size() > 0) {
            StringBuffer stringBuffer3 = new StringBuffer();
            Enumeration enumeration2 = this.resources.keys();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                Integer n4 = (Integer)this.resources.get(string2);
                stringBuffer3.append(this.name(string2) + this.ref(n4));
            }
            string = this.name("XObject") + this.dictionary(stringBuffer3.toString());
        }
        stringBuffer.append(this.name("Resources") + this.dictionary(this.name("ProcSet") + this.array(this.name("PDF") + this.name("Text") + this.name("ImageB")) + "\n" + this.name("Font") + this.dictionary(stringBuffer2.toString()) + string) + "\n");
        stringBuffer.append(this.name("Kids") + "[");
        int n5 = n2;
        while (n5 < n3) {
            stringBuffer.append(this.ref(n5) + "\n");
            ++n5;
        }
        stringBuffer.append("]");
        this.newObject();
        this.produce(this.dictionary("Pages", stringBuffer.toString() + "\n"));
        this.font(NORMAL, "Times-Roman");
        this.font(BOLD, "Times-Bold");
        this.font(FIXED, "Courier");
        this.font(FIXED_BOLD, "Courier-Bold");
        this.font(ALTERNATE, "Helvetica");
        n5 = this.newObject();
        this.produce(this.dictionary("Catalog", this.name("Pages") + this.ref(n3)));
        this.produce("\nendobj\n");
        long l = this.fileOffset;
        int n6 = this.objects.size() + 1;
        this.produce("xref\n0 " + n6 + "\n0000000000 65535 f \n");
        enumeration = this.objects.elements();
        DecimalFormat decimalFormat = new DecimalFormat("0000000000");
        String string3 = " 00000 n ";
        while (enumeration.hasMoreElements()) {
            this.produce(decimalFormat.format((Long)enumeration.nextElement()).getBytes());
            this.produce(string3 + "\n");
        }
        this.produce("trailer\n");
        String string4 = "";
        if (this.isInfo) {
            string4 = "\n" + this.name("Info") + this.ref(n);
        }
        this.produce(this.dictionary(this.name("Size") + " " + n6 + "\n" + this.name("Root") + this.ref(n5) + string4) + "\n");
        this.produce("startxref\n");
        this.produce(l + "\n");
        this.produce("%%EOF");
        this.out.close();
    }

    public void copy(String string) {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
            String string2 = null;
            while ((string2 = lineNumberReader.readLine()) != null) {
                this.println(string2);
            }
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Cannot insert file: " + string);
        }
    }

    public PdfPage(OutputStream outputStream) throws IOException {
        this.out = outputStream;
        this.start();
    }

    public PdfPage(OutputStream outputStream, int n, int n2) throws IOException {
        this.out = outputStream;
        this.setPageWidth(n);
        this.setPageHeight(n2);
        this.start();
    }
}

