/*
 * Decompiled with CFR 0.152.
 */
package us.oh.state.common.utility;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import us.oh.state.common.utility.PdfPage;

public class PdfFormatter {
    private Properties field = null;
    private char tagDelimiter = (char)64;
    private char tagFill = (char)35;
    private String normalFont = PdfPage.FIXED;
    private String boldFont = PdfPage.FIXED_BOLD;
    private int fontSize = 12;

    public void setField(String string, String string2) {
        this.field.put(string.toLowerCase(), string2);
    }

    public String getField(String string) {
        return this.field.getProperty(string.toLowerCase());
    }

    public void setTagDelimiter(char c) {
        this.tagDelimiter = c;
    }

    public char getTagDelimiter() {
        return this.tagDelimiter;
    }

    public void setTagFill(char c) {
        this.tagFill = c;
    }

    public char getTagFill() {
        return this.tagFill;
    }

    public void fontInfo(String string, String string2, int n) {
        this.normalFont = string;
        this.boldFont = string2;
        this.fontSize = n;
    }

    public void compile(InputStream inputStream, PdfPage pdfPage) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) >= 0) {
            if (n == 10) {
                pdfPage.println(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            if (n == this.tagDelimiter) {
                pdfPage.print(stringBuffer.toString());
                stringBuffer.setLength(0);
                while ((n = this.substitute(inputStream, pdfPage)) == this.tagDelimiter) {
                }
                if (n < 0) break;
                if (n == 10) {
                    pdfPage.println(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append((char)n);
                continue;
            }
            stringBuffer.append((char)n);
        }
    }

    private int substitute(InputStream inputStream, PdfPage pdfPage) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = false;
        while ((n = inputStream.read()) >= 0) {
            if (n == 32 || n == 9 || n == 10 || n == this.tagDelimiter) break;
            if (n == this.tagFill) {
                ++n2;
                bl = false;
                continue;
            }
            if (!bl) break;
            if (n2 == 0 && n < 97) {
                pdfPage.setFont(this.boldFont, this.fontSize);
                bl2 = true;
            }
            ++n2;
            stringBuffer.append((char)n);
        }
        String string = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer(++n2);
        String string2 = null;
        if (string.length() > 0) {
            string2 = this.field.getProperty(string.toLowerCase());
        }
        if (string2 == null) {
            while (n2-- > 0) {
                stringBuffer2.append('!');
            }
        } else if (string2.length() > n2) {
            stringBuffer2.append(string2.substring(0, n2));
        } else {
            stringBuffer2.append(string2);
            n2 -= string2.length();
            while (n2-- > 0) {
                stringBuffer2.append(' ');
            }
        }
        pdfPage.print(stringBuffer2.toString());
        if (bl2) {
            pdfPage.setFont(this.normalFont, this.fontSize);
        }
        return n;
    }

    public PdfFormatter() {
        this.field = new Properties();
    }
}

