/*
 * Decompiled with CFR 0.152.
 */
package us.oh.state.common.utility;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import us.oh.state.common.utility.ChartGraphics;
import us.oh.state.common.utility.PdfPage;
import us.oh.state.common.utility.Renderable;
import us.oh.state.common.utility.ValueSet;

public class PdfChart
extends PdfPage
implements ChartGraphics {
    private double xLocation;
    private double yLocation;
    private double chartWidth;
    private double chartHeight;
    private double borderThickness;
    private double topSide;
    private double rightSide;
    private int backgroundColor;
    private int borderColor;
    private Vector valueSets = null;
    private Vector gridX = null;
    private Vector gridY = null;
    private double[] barStack = null;
    private double minorX;
    private double minorY;

    private void init() {
        this.borderThickness = 1.0;
        this.chartHeight = 1.0;
        this.chartWidth = 1.0;
        this.yLocation = 1.0;
        this.xLocation = 1.0;
        this.rightSide = 2.0;
        this.topSide = 2.0;
        this.borderColor = 0xFFFFFF;
        this.backgroundColor = 0xFFFFFF;
    }

    public void appendValues(Renderable renderable) {
        if (this.valueSets == null) {
            this.valueSets = new Vector();
        }
        this.valueSets.addElement(renderable);
    }

    public void appendGridX(double d, int n, int n2) {
        if (this.gridX == null) {
            this.gridX = new Vector();
        }
        PdfChart pdfChart = this;
        if (pdfChart == null) {
            throw null;
        }
        this.gridX.addElement(pdfChart.new GridSetting(d, n, n2));
    }

    public void appendGridY(double d, int n, int n2) {
        if (this.gridY == null) {
            this.gridY = new Vector();
        }
        PdfChart pdfChart = this;
        if (pdfChart == null) {
            throw null;
        }
        this.gridY.addElement(pdfChart.new GridSetting(d, n, n2));
    }

    public void drawMain(double d, double d2, double d3, double d4, int n, int n2, int n3, double d5, int n4) {
        Renderable renderable;
        this.xLocation = d;
        this.yLocation = d2;
        this.chartWidth = d3;
        this.chartHeight = d4;
        this.minorX = d3 / (double)n;
        this.minorY = d4 / (double)n2;
        this.borderThickness = d5;
        this.backgroundColor = n3;
        this.borderColor = n4;
        this.rightSide = this.xLocation + this.chartWidth;
        this.topSide = this.yLocation + this.chartHeight;
        this.setFillColor(n3);
        this.setLineColor(n4);
        this.setLineWidth(d5);
        this.fillRect(this.xLocation, this.yLocation, this.rightSide, this.topSide);
        if (this.valueSets == null) {
            return;
        }
        this.pushGraphicState();
        this.clipRect(this.xLocation, this.yLocation, this.rightSide, this.topSide);
        Enumeration enumeration = this.valueSets.elements();
        while (enumeration.hasMoreElements()) {
            renderable = (Renderable)enumeration.nextElement();
            if (!renderable.isBehindGrid()) continue;
            renderable.render(this);
        }
        if (this.gridX != null) {
            this.drawGrid(true);
        }
        if (this.gridY != null) {
            this.drawGrid(false);
        }
        enumeration = this.valueSets.elements();
        while (enumeration.hasMoreElements()) {
            renderable = (Renderable)enumeration.nextElement();
            if (renderable.isBehindGrid()) continue;
            renderable.render(this);
        }
        this.setBarStack(null);
        this.popGraphicState();
        this.drawRect(this.xLocation, this.yLocation, this.xLocation + this.chartWidth, this.yLocation + this.chartHeight);
    }

    public void drawLegend(double d, double d2, double d3, double d4, double d5, double d6, int n, double d7, int n2) {
        ValueSet valueSet;
        double d8 = d + d3;
        double d9 = d2 + d4;
        d6 /= 2.0;
        this.pushGraphicState();
        this.setFillColor(n);
        this.setLineColor(n2);
        this.setLineWidth(d7);
        this.fillRect(d, d2, d8, d9);
        if (this.valueSets == null) {
            return;
        }
        double d10 = d4 / (double)(this.valueSets.size() + 1);
        double d11 = (d += d10 / 2.0) + d5 / 2.0;
        d2 = d9;
        Enumeration enumeration = this.valueSets.elements();
        enumeration = this.valueSets.elements();
        while (enumeration.hasMoreElements()) {
            valueSet = (ValueSet)enumeration.nextElement();
            valueSet.sample(this, d, d11, d2 -= d10, d6);
        }
        this.popGraphicState();
        d2 = d9 - d6;
        d += d5 + d10 / 2.0;
        enumeration = this.valueSets.elements();
        while (enumeration.hasMoreElements()) {
            valueSet = (ValueSet)enumeration.nextElement();
            this.printTextRotated(d, d2 -= d10, 0.0, valueSet.getName());
        }
    }

    private void drawGrid(boolean bl) {
        Vector vector = this.gridX;
        if (!bl) {
            vector = this.gridY;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            double d;
            GridSetting gridSetting = (GridSetting)enumeration.nextElement();
            this.setLineColor(gridSetting.color);
            this.setLineWidth(gridSetting.thickness);
            if (bl) {
                d = this.xLocation;
                while (!((d += this.minorX * (double)gridSetting.perMinor) >= this.rightSide)) {
                    this.moveTo(d, this.yLocation);
                    this.drawTo(d, this.topSide);
                }
                continue;
            }
            d = this.yLocation;
            while (!((d += this.minorY * (double)gridSetting.perMinor) >= this.topSide)) {
                this.moveTo(this.xLocation, d);
                this.drawTo(this.rightSide, d);
            }
        }
    }

    public void drawBottomLabels(double d, double d2, double d3, String[] stringArray, double d4) {
        double d5 = this.xLocation + d;
        double d6 = this.yLocation - d2;
        double d7 = this.chartWidth / 2.0;
        if (stringArray.length == 1) {
            this.printTextRotated(d5 + d7, d6, d3, stringArray[0]);
        } else {
            d7 = this.chartWidth / (double)(stringArray.length - 1);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    this.printTextRotated(d5 + d7 * (double)n, d6, d3, stringArray[n]);
                    this.moveTo(this.xLocation + d7 * (double)n, this.yLocation);
                    this.drawTo(this.xLocation + d7 * (double)n, this.yLocation - d4);
                }
                ++n;
            }
        }
    }

    public void drawLeftLabels(double d, double d2, double d3, String[] stringArray, double d4) {
        double d5 = this.xLocation - d;
        double d6 = this.yLocation + d2;
        double d7 = this.chartHeight / 2.0;
        if (stringArray.length == 1) {
            this.printTextRotated(d5, d6 + d7, d3, stringArray[0]);
        } else {
            d7 = this.chartHeight / (double)(stringArray.length - 1);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    this.printTextRotated(d5, d6 + d7 * (double)n, d3, stringArray[n]);
                    this.moveTo(this.xLocation, this.yLocation + d7 * (double)n);
                    this.drawTo(this.xLocation - d4, this.yLocation + d7 * (double)n);
                }
                ++n;
            }
        }
    }

    public double[] getBarStack() {
        return this.barStack;
    }

    public void setBarStack(double[] dArray) {
        this.barStack = dArray;
    }

    public double getRightSide() {
        return this.rightSide;
    }

    public double getWidth() {
        return this.chartWidth;
    }

    public double getHeight() {
        return this.chartHeight;
    }

    public double getXLocation() {
        return this.xLocation;
    }

    public double getYLocation() {
        return this.yLocation;
    }

    public PdfChart(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.init();
    }

    public PdfChart(OutputStream outputStream, int n, int n2) throws IOException {
        super(outputStream, n, n2);
        this.init();
    }

    private class GridSetting {
        double thickness;
        int perMinor;
        int color;

        GridSetting(double d, int n, int n2) {
            this.thickness = d;
            this.perMinor = n;
            this.color = n2;
        }
    }
}

