/*
 * Decompiled with CFR 0.152.
 */
package us.oh.state.common.utility;

import us.oh.state.common.utility.ChartGraphics;
import us.oh.state.common.utility.ValueSet;

public class LineValueSet
extends ValueSet {
    private double indBeginRange;
    private double indEndRange;
    private double depMinValue;
    private double depMaxValue;
    private double incr;

    public void render(ChartGraphics chartGraphics) {
        chartGraphics.setLineColor(this.getLineColor());
        chartGraphics.setLineWidth(this.getLineThickness());
        int n = this.getValueCount();
        double d = chartGraphics.getWidth() / (double)(n - 1);
        this.setScale(chartGraphics.getHeight());
        double d2 = chartGraphics.getXLocation();
        double d3 = chartGraphics.getYLocation();
        chartGraphics.moveTo(d2, d3 + this.getFirstValue());
        while (--n > 0) {
            chartGraphics.drawTo(d2 += d, d3 + this.getNextValue());
        }
    }

    public void sample(ChartGraphics chartGraphics, double d, double d2, double d3, double d4) {
        chartGraphics.setLineColor(this.getLineColor());
        chartGraphics.setLineWidth(this.getLineThickness());
        chartGraphics.moveTo(d, d3);
        chartGraphics.drawTo(d + (d2 - d) * 2.0, d3);
    }

    public LineValueSet(String string, double d, int n, double[] dArray, double d2, double d3) {
        super(string, d, n, dArray);
        this.indBeginRange = d2;
        this.indEndRange = d3;
        this.incr = (d3 - d2) / (double)(dArray.length - 1);
    }
}

