/*
 * Decompiled with CFR 0.152.
 */
package us.oh.state.common.utility;

import us.oh.state.common.utility.ChartGraphics;
import us.oh.state.common.utility.LineValueSet;

public class GlyphValueSet
extends LineValueSet {
    private int fillColor;
    private double[] glyphCoords;
    private boolean isConnected = false;

    public int getFillColor() {
        return this.fillColor;
    }

    public void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    public boolean getConnected() {
        return this.isConnected;
    }

    public double[] getGlyphCoords() {
        return this.glyphCoords;
    }

    public void render(ChartGraphics chartGraphics) {
        chartGraphics.setLineColor(this.getLineColor());
        chartGraphics.setLineWidth(this.getLineThickness());
        chartGraphics.setFillColor(this.getFillColor());
        int n = this.getValueCount();
        double d = chartGraphics.getWidth() / (double)(n - 1);
        this.setScale(chartGraphics.getHeight());
        double d2 = chartGraphics.getXLocation();
        double d3 = chartGraphics.getYLocation();
        if (this.getConnected()) {
            chartGraphics.moveTo(d2, d3 + this.getFirstValue());
            while (--n > 0) {
                chartGraphics.drawTo(d2 += d, d3 + this.getNextValue());
            }
        }
        n = this.getValueCount();
        d2 = chartGraphics.getXLocation();
        chartGraphics.moveTo(d2, d3 + this.getFirstValue());
        double[] dArray = this.getGlyphCoords();
        int n2 = dArray.length / 2;
        while (--n > 0) {
            double d4 = d2 += d;
            double d5 = d3 + this.getNextValue();
            int n3 = 0;
            while (n3 < n2) {
                double d6 = d4 + dArray[n3 * 2];
                double d7 = d5 + dArray[n3 * 2 + 1];
                if (n3 == 0) {
                    chartGraphics.moveTo(d6, d7);
                } else {
                    chartGraphics.drawTo(d6, d7);
                }
                ++n3;
            }
            chartGraphics.fillPoly();
        }
    }

    public void sample(ChartGraphics chartGraphics, double d, double d2, double d3, double d4) {
        chartGraphics.setLineColor(this.getLineColor());
        chartGraphics.setLineWidth(this.getLineThickness());
        chartGraphics.setFillColor(this.getFillColor());
        if (this.getConnected()) {
            chartGraphics.moveTo(d, d3);
            chartGraphics.drawTo(d + (d2 - d) * 2.0, d3);
        }
        double[] dArray = this.getGlyphCoords();
        int n = dArray.length / 2;
        int n2 = 0;
        while (n2 < n) {
            double d5 = d2 + dArray[n2 * 2];
            double d6 = d3 + dArray[n2 * 2 + 1];
            if (n2 == 0) {
                chartGraphics.moveTo(d5, d6);
            } else {
                chartGraphics.drawTo(d5, d6);
            }
            ++n2;
        }
        chartGraphics.fillPoly();
    }

    public GlyphValueSet(String string, double d, int n, double[] dArray, double d2, double d3, int n2, double[] dArray2) {
        super(string, d, n, dArray, d2, d3);
        this.fillColor = n2;
        this.glyphCoords = dArray2;
    }
}

