/*
 * Decompiled with CFR 0.152.
 */
package us.oh.state.common.utility;

import us.oh.state.common.utility.ChartGraphics;
import us.oh.state.common.utility.ValueSet;

public class BarValueSet
extends ValueSet {
    private int barColor;
    private double barWidth;
    private boolean isStackable = false;
    private double offsetDistance = 0.0;

    public void setStackable(boolean bl) {
        this.isStackable = bl;
    }

    public boolean getStackable() {
        return this.isStackable;
    }

    public int getFillColor() {
        return this.barColor;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(double d) {
        this.barWidth = d;
    }

    public void setOffset(double d) {
        this.offsetDistance = d;
    }

    public double getOffset() {
        return this.offsetDistance;
    }

    public void render(ChartGraphics chartGraphics) {
        chartGraphics.setLineColor(this.getLineColor());
        chartGraphics.setLineWidth(this.getLineThickness());
        chartGraphics.setFillColor(this.getFillColor());
        int n = this.getValueCount();
        double d = chartGraphics.getWidth() / (double)(n + 1);
        this.setScale(chartGraphics.getHeight());
        double d2 = chartGraphics.getYLocation() + this.getBaseValue();
        double[] dArray = chartGraphics.getBarStack();
        if (this.getStackable() && dArray == null) {
            dArray = new double[this.getValueCount()];
            chartGraphics.setBarStack(dArray);
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray[n2] = d2;
                ++n2;
            }
        }
        double d3 = chartGraphics.getXLocation() - this.getBarWidth() / 2.0 + this.getOffset();
        double d4 = d3 + this.getBarWidth();
        int n3 = 0;
        while (n-- > 0) {
            if (this.getStackable()) {
                double d5 = dArray[n3] + this.getNextValue();
                chartGraphics.fillRect(d3 += d, dArray[n3], d4 += d, d5);
                dArray[n3] = d5;
                ++n3;
                continue;
            }
            chartGraphics.fillRect(d3 += d, d2, d4 += d, d2 + this.getNextValue());
        }
    }

    public void sample(ChartGraphics chartGraphics, double d, double d2, double d3, double d4) {
        chartGraphics.setLineColor(this.getLineColor());
        chartGraphics.setLineWidth(this.getLineThickness());
        chartGraphics.setFillColor(this.getFillColor());
        chartGraphics.fillRect(d2 - d4, d3 - d4, d2 + d4, d3 + d4);
    }

    public BarValueSet(String string, double d, int n, double[] dArray, int n2, double d2) {
        super(string, d, n, dArray);
        this.barColor = n2;
        this.barWidth = d2;
    }
}

