/*
 * Decompiled with CFR 0.152.
 */
package us.oh.state.common.utility;

import us.oh.state.common.utility.ChartGraphics;
import us.oh.state.common.utility.LineValueSet;

public class AreaValueSet
extends LineValueSet {
    private int fillColor;
    private boolean behindGrid;

    public int getFillColor() {
        return this.fillColor;
    }

    public boolean isBehindGrid() {
        return this.behindGrid;
    }

    public void setBehindGrid(boolean bl) {
        this.behindGrid = bl;
    }

    public void render(ChartGraphics chartGraphics) {
        chartGraphics.setLineColor(this.getLineColor());
        chartGraphics.setLineWidth(this.getLineThickness());
        chartGraphics.setFillColor(this.getFillColor());
        int n = this.getValueCount();
        double d = chartGraphics.getWidth() / (double)(n - 1);
        this.setScale(chartGraphics.getHeight());
        double d2 = chartGraphics.getXLocation();
        chartGraphics.moveTo(chartGraphics.getXLocation(), chartGraphics.getYLocation());
        double d3 = chartGraphics.getYLocation();
        chartGraphics.drawTo(d2, d3 + this.getFirstValue());
        while (--n > 0) {
            chartGraphics.drawTo(d2 += d, d3 + this.getNextValue());
        }
        chartGraphics.drawTo(chartGraphics.getRightSide(), d3);
        chartGraphics.fillPoly();
    }

    public void sample(ChartGraphics chartGraphics, double d, double d2, double d3, double d4) {
        chartGraphics.setLineColor(this.getFillColor());
        chartGraphics.setLineWidth(this.getLineThickness());
        chartGraphics.setFillColor(this.getFillColor());
        double d5 = d + (d2 - d) * 2.0;
        chartGraphics.fillRect(d, d3 - d4, d5, d3 + d4);
        chartGraphics.setLineColor(this.getLineColor());
        chartGraphics.moveTo(d, d3 + d4);
        chartGraphics.drawTo(d5, d3 + d4);
    }

    public AreaValueSet(String string, double d, int n, double[] dArray, double d2, double d3, int n2, boolean bl) {
        super(string, d, n, dArray, d2, d3);
        this.fillColor = n2;
        this.behindGrid = bl;
    }
}

